% ex4_3.m
% Example 4.3; Fig. 4.1
clear

x0=0;    % initial value of x0
Pxx=5;   % initial variance of x0
Pth=1;   % initial variance of th
q=0.36;
r=0.25;
M=1000;
N=100;
t=0:N;
th=0.9;
w=sqrt(q)*randn(M,N);
x=zeros(M,N+1);
u=0.5*sin(2*t*pi/50);
%u=randn(1,N+1);
for j=1:M
x(j,1)=x0;
    for i=1:N
        x(j,i+1)=x(j,i)*th+ u(i) + w(j,i);
    end
end 
mx=mean(x);
cov11=zeros(1,N+1);
for i=1:N+1
    cov11(1,i)=x(:,i)'*x(:,i)/M;
end
% Information matrix  Eq.(4.39)
D11=th*th/q;
D12=(2*th*mx(1:N)-mx(2:N+1)+u(1:N))/q;
D13=-th/q;
D22=cov11(1,1:N)/q;
D23=-mx(1:N)/q; 
D33=1/q;

CC=zeros(2,2,N+1);
J0=zeros(2,2,N+1);   % J_{t/t-1}
JJ=zeros(2,2,N+1);   % J_{t/t}
J0(:,:,1)=[1/Pxx 0;
    0  1/Pth];
Kt=[1/r 0;
    0 0];
for i=1:N                    % Theorem 4.4 p. 77
JJ(:,:,i)=J0(:,:,i) + Kt;    % Eq.(4.38)
Del=JJ(1,1,i)+D11;
Dt12=JJ(1,2,i)+D12(i);
J0(1,1,i+1)=D33-D13'*inv(Del)*D13;
J0(1,2,i+1)=D23(i)'-D13'*inv(Del)*Dt12;
J0(2,1,i+1)=J0(1,2,i+1);
J0(2,2,i+1)=JJ(2,2,i)+D22(i)-Dt12'*inv(Del)*Dt12;
CC(:,:,i)=inv(JJ(:,:,i));
end
CC(:,:,N+1)=inv(J0(:,:,N+1)+Kt);
V1=zeros(1,N+1);
V2=zeros(1,N+1);
for i=1:N+1
V1(1,i)=CC(1,1,i);
V2(1,i)=CC(2,2,i);
end

figure(1)
semilogy(t,V1,'b',t,V2,'r-','LineWidth',1.5)
grid
xlabel('Number of steps t')
ylabel('Variances')
title('Fig. 4.1: Cramer Lower Bounds')
legend('V^{xx}_{t}','V^{\theta\theta}_t')
hold on


